string GetDescription()
{
	return "This is an advanced piano arrangement in the disco style.";
}

void Arrange(Song @s)
{
	int bars = s.GetBars();
	
	s.AddTrack("Melody", 6,127,64);
	s.AddTrack("Alt Voice", 5,127,64);
	s.AddTrack("Accomp", 5,127,64);
	s.AddTrack("Chorus Intro", 4,127,64);
	s.AddTrack("Accomp boost", 6,127,64);
	
	int intro_seed = RndInt(0,32000);
	
	for (int i = 0; i < s.GetParts(); i++)
	{
		int end = s.GetPartEndBar(i);
		
		if (i == s.GetParts()-1) end--;
		
		if (s.GetPart(i).GetArrHint() == 0)
		{
			s.AddRenderEvent("Shortest Way Chords Simple", RndInt(0,32000), RndInt(0,1), s.GetPartStartBar(i), s.GetPartEndBar(i), RndInt(1,2), CreateTime(0,0),0.8); 			
		}
		
		if (s.GetPart(i).GetArrHint() == 1)
		{
			s.AddRenderEvent("Simple Melody", RndInt(0,32000), 0, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),1.0); 			
		}
		
		if (s.GetPart(i).GetArrHint() == 2)
		{
			s.AddRenderEvent("Simple Melody", RndInt(0,32000), 1, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),1.0); 		
		}
		
		if (s.GetPart(i).GetArrHint() == 3)
		{
			s.AddRenderEvent("Simple Melody", RndInt(0,32000), 0, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),1.0); 		
			s.AddRenderEvent("Simple Melody", RndInt(0,32000), 1, s.GetPartStartBar(i), s.GetPartEndBar(i), 2, CreateTime(0,0),1.0); 		
			s.AddRenderEvent("Disco Jumping Bass", RndInt(0,32000), 4, s.GetPartStartBar(i), end, -1, CreateTime(0,0),1.0); 
			s.AddRenderEvent("Random Bass", RndInt(0,32000), 3, s.GetPartStartBar(i), end, RndInt(0,2), CreateTime(0,0),0.8); 			
		}
	}
	
	s.AddRenderEvent("Quick Intro Bass", intro_seed, 3,bars-1, bars, -1, CreateTime(1,0),1.0); 					
	s.AddRenderEvent("Quick Intro Bass", intro_seed, 3,bars-1, bars, 0, CreateTime(1,0),1.0); 					
	s.AddRenderEvent("Simple Chords", RndInt(0,32000), 3, bars-1, bars, 2, CreateTime(0,0),1.0); 			
	s.AddRenderEvent("Simple Chords", RndInt(0,32000), 3, bars-1, bars, 3, CreateTime(1,0),1.0); 			
	s.AddRenderEvent("Disco Jumping Bass", RndInt(0,32000), 2, 0, bars-1, 0, CreateTime(0,0),0.9); 		
}